Started....03/07/21
' Microcontroller used:  Microchip Technology PIC16F690
'                        microchip.com
' PicBasic Pro Code: micro-Engineering Labs, Inc.
'                    melabs.com 

'--------Program Desciption--------
' 
'Recognises the different coloured blocks red, green, blue, yellow, white  
'and displays the % of red, % of green and % blue.r colour on an LCD 
                                                                      
  #CONFIG
     __config (_INTRC_OSC_NOCLKOUT & _WDT_OFF & _PWRTE_ON & _MCLRE_ON & _CP_OFF & _BOR_OFF & _IESO_OFF & _FCMEN_OFF)    
 
  #ENDCONFIG
 
 DEFINE OSC 4 '4Mhz osc
 OSCCON = %01100000  '4MHZ OSC   
 DEFINE SHIFT_PAUSEUS 1000  '1ms for MAX6675 conversion time  
 DEFINE LCD_DREG    PORTC  'set LCD DATA port to C
 DEFINE LCD_DBIT    4       'set starting DATA bit (0 or 4) if 4-bit change to 0 if starting at DB0
 DEFINE LCD_RSREG    PORTC   ' Set LCD Register Select port
 DEFINE LCD_RSBIT	2       ' Set LCD Register Select bit to PORTC.2
 DEFINE LCD_EREG	PORTC       ' Set LCD Enable port
 DEFINE LCD_EBIT	3           ' Set LCD Enable bit set to PORTC.3
 DEFINE LCD_BITS	4           ' Set LCD bus size (4 or 8 bits)
 DEFINE LCD_LINES	4       ' Set number of lines on LCD
 DEFINE LCD_COMMANDUS    2000  ' Set command delay time in us
 DEFINE LCD_DATAUS	50      ' Set data delay time in us
 define ADC_BITS 10
 Define  ADC_CLOCK    3     ' Set clock source (3=rc)
 define  ADC_SAMPLEUS 50
 
 
OPTION_REG = %11000000 ' PORT A&B Pull-Ups disabled, interrupt rising edge RA2 
INTCON     = %00010000 ' Interrupt on RA2 if bit 7 global interrupt is 0 then program 
'execution will resume on the line after NAP
ANSEL      = %00000000 ' all digital
ANSELH     = %00010000 ' RB4 analogue rest digital
ADCON0     = %10010101 ' A/D Module is on,ch5 sel, Vdd ref, right justified 
CM1CON0    = %00000000 ' Comparator1 Module is OFF
CM2CON0    = %00000000 ' Comparator2 Module is OFF
WDTCON.0 = 0'watch dog timer off     
TRISA      = %00001100 ' RA2 Interrupt,RA3 MCRL inputs, rest outputs 
TRISB      = %00000000 ' all outputs  
TRISC      = %00000010 ' all outputs except RC1 analogue input for LDR                                                                                               
 
 '------------Variables-------------

Z var word  ' measurement time
redc var word  'red cal value
greenc var word 'green cal value
bluec var word 'blue cal value
redm var word  'red measured value
greenm var word 'green measured value
bluem var word ' blue measure value
redd var word ' red % display
greend var word'green % display
blued var word ' blue % display
sum var word   ' sum of k + m + n
dummy var word ' for div 32
k var word '(redc * 2000)/redm. This is 10 times the reading
m var word '(greenc *2000 )/ greenm. This is 10 times the reading
n var word '(bluec *2000 )/ bluem. This is 10 times the reading 
p var word '(K * 1000)/sum
q var word '(m * 1000)/sum 
r var word '(n * 1000)/sum

'----------Initialization----------

  PORTB.5 = 1 'Red off 
  PORTB.4 = 1 'green off
  PORTA.5 = 1 'Blue off  
 
  redc = 0
  greenc = 0
  bluec = 0
  redm = 0
  greenm = 0
  bluem = 0   
  redd = 0
  greend = 0
  blued = 0
  sum = 0   
  Z = 300
  dummy = 0
  k = 0
  m = 0
  n = 0
  p = 0
  q = 0
  r = 0
'-------------Main Code------------

   pause 300' initiliasion delay
   Main:   
   Calibrate: 'white card in front of sensor to calibrate    
   
   PORTB.5 = 0 ' Red on
   Pause Z ' Allow LDR to settle
   ADCIN 5 ,redc 
   pause 1 
   PORTB.5 = 1' red off
   PORTB.4 = 0' green on
   Pause Z ' Allow LDR to settle
   ADCIN 5 ,greenc
   pause 1
   PORTB.4 = 1 'green off
   PORTA.5 = 0 'blue on
   Pause Z ' Allow LDR to settle
   ADCIN 5, bluec
   pause 1
   PORTA.5 = 1 'blue off      
   
   LCDOUT $FE,$01  'clear display
   LCDOUT $FE,$80," CAL ","R = ",dec redc     
   lcdout $FE,$C0,"G = ",dec greenc," B = ",dec bluec
   
   INTCON.1 = 0
   nap 7
   Measure:
   LCDOUT $FE,$01  'clear display    
   
   PORTB.5 = 0 ' Red on
   Pause Z ' Allow LDR to settle
   ADCIN 5 ,redm 
   pause 1 
   PORTB.5 = 1' red off
   PORTB.4 = 0' green on
   Pause Z ' Allow LDR to settle
   ADCIN 5 ,greenm
   pause 1
   PORTB.4 = 1 'green off
   PORTA.5 = 0 'blue on
   Pause Z ' Allow LDR to settle
   ADCIN 5, bluem
   pause 1
   PORTA.5 = 1 'blue off
   
  dummy = 0 'reset dummy
   dummy = redc * 2000
   k = DIV32 redm  'k = (redc * 2000)/redm. This is 10 times the reading 
      
   dummy = 0 'reset dummy
   dummy = greenc * 2000
   m = div32 greenm ' m = (greenc *2000 )/ greenm. This is 10 times the reading  
  
   dummy = 0 'reset dummy
   dummy = bluec * 2000
   n = div32 bluem ' m = (bluec *2000 )/ bluem. This is 10 times the reading  
   
    sum = (k + m + n)
 dummy = 0
 dummy = k * 1000
 p = div32 sum '(K * 1000)/sum
 redd = (p + 5)/10 'round up 

dummy = 0
dummy = m * 1000
q = div32 sum '( m*1000)/sum    
 greend = (q + 5)/10 'round up
 
 dummy = 0
 dummy = n *1000
 r = div32 sum '(n * 1000)/sum  
 blued = (r + 5)/10 'round up   
  
   if redd > greend and redd > blued and (redd-greend)>15 then goto DIP2 'red
   
   if greend > blued and greend > redd then goto DIP3 'green
  
   if blued > redd and blued > greend then goto DIP4  'blue
   
   if redd > BLUEd and greend > blued and (redd-greend) <15 and (redd-greend) > 2 then goto DIP5 ' yellow. >2 avoids white being shown as yellow 
  
  if (redd-greend)< 3 and (redd-blued) <3 and (Blued-greend) <3 then goto DIP6  'white
  
   DIP1:
  
   LCDOUT $FE,$01  'clear display
   lcdout $FE,$80, " COLOUR ----    "
   LCDOUT $FE,$C0," R",dec redd,"%"," G",dec greend,"%"," B",dec blued,"%"    
   INTCON.1 = 0
   nap 7
   goto Measure    
   
   DIP2:   
   
   LCDOUT $FE,$01  'clear display
   lcdout $FE,$80, " COLOUR RED     "      
   LCDOUT $FE,$C0," R",dec redd,"%"," G",dec greend,"%"," B",dec blued,"%"   
   INTCON.1 = 0
   nap 7
   goto Measure
   
   DIP3:   
  
   LCDOUT $FE,$01  'clear display
   lcdout $FE,$80, " COLOUR GREEN   "  
   LCDOUT $FE,$C0," R",dec redd,"%"," G",dec greend,"%"," B",dec blued,"%"    
   INTCON.1 = 0
   nap 7
   goto Measure
   
   DIP4:   
   
   LCDOUT $FE,$01  'clear display
   lcdout $FE,$80, " COLOUR BLUE    "     
   LCDOUT $FE,$C0," R",dec redd,"%"," G",dec greend,"%"," B",dec blued,"%"    
   INTCON.1 = 0
   nap 7
   goto measure
  
   DIP5:    
   
   LCDOUT $FE,$01  'clear display
   lcdout $FE,$80, " COLOUR YELLOW  "   
   LCDOUT $FE,$C0," R",dec redd,"%"," G",dec greend,"%"," B",dec blued,"%"
   INTCON.1 = 0
   nap 7
   goto measure    
  
   DIP6:
   LCDOUT $FE,$01  'clear display
   lcdout $FE,$80, " COLOUR WHITE  "    
   LCDOUT $FE,$C0," R",dec redd,"%"," G",dec greend,"%"," B",dec blued,"%"   
   INTCON.1 = 0
   nap 7
   goto Measure
   
 

  
  
   
  